*** COS 2019 01, last update 2022 11  
           
program define dq_des_dqg1  
syntax varlist(max=1 numeric) [if] [in]	, [stratavar(varname numeric)  dqinumber(int 0)]							///  
			[textsize(real 7.5) bartextsize(int 6) graphtextscalefactor(real 1.1) ysize(int 3) xsize(int 20)]      	///  
 			[gd(string) structure(string) reportname(string) forcecalc(int 1)  indent(int 0)]  
marksample touse, novarlist  
// HOTFIX touse disabled  
local indent=`indent'+5  
local adoname "dq_des_dqg1"  
local text_i "di as text _n "  					  
local dqisummarygraph "`gd'\dqisummary_`structure'_`varlist'.png"  
capture confirm file `dqisummarygraph'	  
if _rc>0 | `forcecalc'>0  {											  
	          
	local barstyle=""												  
	local dqilabel=""												  
	capture  lab drop dqilab										  
	          
	capture drop `outputvar'  
	tempvar outputvar												  
	qui gen `outputvar'=.  
	if "`=dqi_dimension_mddq`dqinumber''"=="Accuracy" local touse "modified==1"  
		else local touse "modified==0"  
		         
	          
	if `dqinumber'>0 {  
		local barnum=0												  
		forvalues n=1/`=dqi_catnum_mddq`dqinumber'' {				  
			qui count if `varlist' ==`n' & `touse'				  
			if r(N)>0 {  
				local barnum = `barnum'+1  
				local barstyle=`"`barstyle' bar(`barnum', bfcolor("`=dqi_cat_color_`n'_mddq`dqinumber''") blcolor("`=dqi_cat_color_`n'_mddq`dqinumber''"))"'  
								   
				local dqilabel=`"`dqilabel' `barnum' "`=dqi_cat_name_`n'_mddq`dqinumber'' " "'  
				qui replace `outputvar'=`barnum' if `varlist' ==`n'	  
			}       
			local dqilabel2=`"`dqilabel' `n' "`=dqi_cat_name_`n'_mddq`dqinumber'' " "'  
		}        
		capture lab def dqilab `dqilabel'  
		lab val `outputvar' dqilab  
		qui tab `outputvar'	if `touse'	  
		capture lab def dqilab2 `dqilabel2'  
		lab val `varlist' dqilab2  
		qui tab `varlist' if `touse'			  
	}         
	          
	          
	qui levelsof(`stratavar') if `varlist'	<100  
	local outputlevels=wordcount("`r(levels)'")								  
	local gapnumber=max(0, 450-`outputlevels'*90)							  
	if `outputlevels'>5 	local textsize=max(7-`outputlevels'/6,1) 		  
	if `outputlevels'>5 	local bartextsize=max(7-`outputlevels'/6,1) 	  
	if `outputlevels'>5     local ysize=3+`outputlevels'/7  
	local graphtextscalefactor=1.1-max(`outputlevels'/100,0.3)  
	          
	          
	local legendleft  "legend(on order(`dqilabel') pos(left) cols(1) region(lwidth(none)) size(`textsize'))"  
	local legendright "legend(off)"  
	if `outputlevels'>15 {		//  
		local legendleft  "legend(on order(`dqilabel') pos(bottom) rows(1) region(lwidth(none)) size(`textsize'))"  
		local legendright "legend(on order(`dqilabel') pos(bottom) rows(1) region(lwidth(none)) size(`textsize'))"  
	}         
	catplot `outputvar' if `touse', asyvars  outergap(`gapnumber') over(`stratavar', label(labsize(`textsize'))) 								///  
				blabel(bar, pos(center)format(%2.0f) orientation(horizontal) bexpand size(`bartextsize') color($framecolor)) 					///  
				`legendleft' stack   									///  
				graphregion(fcolor($framecolor)) `barstyle' ytitle("$numvars_1", size(`textsize')) l1title("")  ylabel(, labsize(`textsize'))  	///  
				name(g1, replace)  
	graph close g1  
	          
	catplot `outputvar' if `touse', asyvars  outergap(`gapnumber')  over(`stratavar', label(labsize(`textsize')))  											///  
				percent(`stratavar')  blabel(bar, pos(center) format(%2.0f) orientation(horizontal) bexpand size(`bartextsize') color($framecolor)) 		///  
				`legendright' stack 																														 	///  
				graphregion(fcolor($framecolor)) `barstyle' ytitle("$Percent_1", size(`textsize') ) l1title("") ylabel(, labsize(`textsize'))  				///  
				name(g2, replace)  
	graph close g2  
	          
	capture gr combine g1 g2, iscale(`graphtextscalefactor') ysize(`ysize') xsize(`xsize') graphregion(fcolor($framecolor))		  
	if _rc>0 {  
	}	        
	          
	local height=$dqigraphheight  
	if `outputlevels'>5 local height=30 + min(1600,`outputlevels'*31)			  
	qui graph export "`dqisummarygraph'", replace width($graphfullpagewidth) height(`height')  
	          
}	         
	          
end	       
